"""
===============================================================================
    Projekt: Moduláris Esőkert Számítási Programok
    Fejlesztő: Glia Kutatás - Fejlesztési Innovációs Kft.
    Weboldal: www.glia.hu
    Verzió: 1.0
    Dátum: 2018
    Licenc: Nyílt forráskódú szoftver (MIT Licenc)

    Pályázati támogatás:
    Ez a fejlesztés a GINOP-2.1.7-15-2016-02435 pályázat keretén belül 
    valósult meg, amely célja a moduláris beton-műanyag kompozit szikkasztó 
    rendszer fejlesztése volt és a Glia Kft. tarnabodi telephelyén került megvalósításra.

    Leírás:
    Ez a program a moduláris esőkert különböző hidrológiai paramétereinek 
    számítására szolgál. Tartalmazza az alábbi funkciókat:
    - Kapilláris vízemelés számítása
    - Infiltráció és vízbeszivárgás számítása
    - Vízmozgás sebességének becslése
    - Párolgás és evapotranszspiráció számítása
    - Esőkert tározási kapacitás és túlcsordulás vizsgálata

    Licencfeltételek:
    Ez a szoftver az MIT Licenc alatt áll, így szabadon másolható, módosítható 
    és terjeszthető, feltéve hogy a fent megnevezett fejlesztői jogokat 
    és a licencfeltételeket tiszteletben tartják.
===============================================================================
"""

import argparse

def rain_garden_capacity(area, depth, water_content):
    """
    Kiszámítja az esőkert tározási kapacitását.

    Paraméterek:
        area (float): Esőkert felszíni területe (m²)
        depth (float): Talajréteg mélysége (m)
        water_content (float): Talaj tényleges víztartalma (dimenzió nélküli)

    Visszatérés:
        float: Tárolható vízmennyiség (m³)
    """
    return area * depth * water_content

def rainfall_input(runoff_coefficient, rainfall, catchment_area):
    """
    Kiszámítja az esőkertbe érkező vízmennyiséget csapadék és vízgyűjtő terület alapján.

    Paraméterek:
        runoff_coefficient (float): Lefolyási tényező (0-1 között)
        rainfall (float): Csapadékmennyiség (m)
        catchment_area (float): Vízgyűjtő felület (m²)

    Visszatérés:
        float: Esőkertbe érkező csapadékvíz mennyisége (m³)
    """
    return runoff_coefficient * rainfall * catchment_area

def overflow_calculation(p, v):
    """
    Kiszámítja az esőkert túlcsordulását.

    Paraméterek:
        p (float): Esőkertbe érkező vízmennyiség (m³)
        v (float): Esőkert teljes tározási kapacitása (m³)

    Visszatérés:
        float: Túlcsordulás (m³), ha pozitív, az esőkert nem képes minden vizet elnyelni.
    """
    return max(0, p - v)  # Ha nincs túlcsordulás, az eredmény 0

def main():
    """
    Parancssori argumentumokkal kiszámítja az esőkert tározási kapacitását, a beérkező vizet és a túlcsordulást.
    """
    parser = argparse.ArgumentParser(description="Esőkert túlcsordulás számítása.")

    # Esőkert paraméterei
    parser.add_argument("--area", type=float, required=True, help="Esőkert felszíni területe (m²)")
    parser.add_argument("--depth", type=float, required=True, help="Talajréteg mélysége (m)")
    parser.add_argument("--water_content", type=float, required=True, help="Talaj tényleges víztartalma (dimenzió nélküli)")

    # Csapadék és vízgyűjtő terület paraméterei
    parser.add_argument("--runoff_coefficient", type=float, required=True, help="Lefolyási tényező (0-1)")
    parser.add_argument("--rainfall", type=float, required=True, help="Csapadékmennyiség (m)")
    parser.add_argument("--catchment_area", type=float, required=True, help="Vízgyűjtő felület mérete (m²)")

    # Argumentumok beolvasása
    args = parser.parse_args()

    # Tározási kapacitás számítása
    v = rain_garden_capacity(args.area, args.depth, args.water_content)

    # Esőkertbe érkező vízmennyiség
    p = rainfall_input(args.runoff_coefficient, args.rainfall, args.catchment_area)

    # Túlcsordulás számítása
    overflow = overflow_calculation(p, v)

    # Eredmények kiírása
    print("\n🌧️ Esőkert Túlcsordulás Számítása:")
    print(f"🌿 Tárolható vízmennyiség: {v:.2f} m³")
    print(f"💧 Esőkertbe érkező csapadékvíz mennyisége: {p:.2f} m³")
    print(f"⚠️ Túlcsordulás: {overflow:.2f} m³")

if __name__ == "__main__":
    main()

